import ntptime
import network,time
import machine
from machine import Pin,RTC

rtc = RTC()
#print("同步前本地时间：%s" %str(time.localtime()))
led=Pin(2,Pin.OUT)

# 联WIFI
def WIFI_Connect():

    wlan = network.WLAN(network.STA_IF) #STA模式
    wlan.active(True)                   #激活接口
    start_time=time.time()              #记录时间做超时判断
    if not wlan.isconnected():
        print('connecting to network...')
        wlan.connect('HUAWEI-WULIAN', 'onlychina') #输入WIFI账号密码
        while not wlan.isconnected():
            if time.time()-start_time > 15 :
                print('WIFI Connected Timeout!')
                break
    if wlan.isconnected():
        print('connected!')
        print('network information:', wlan.ifconfig())

# 同步时间
def sync_ntp():
     ntptime.NTP_DELTA = 3155644800   # 可选 UTC+8偏移时间（秒），不设置就是UTC0
     ntptime.host = 'ntp1.aliyun.com'  # 可选，ntp服务器，默认是"pool.ntp.org"
     try:
         ntptime.settime()   # 修改设备时间,到这就已经设置好了
     except:
         for i in range(6):
            led.value(1)              #turn off 0是亮
            time.sleep(0.1)
            led.value(0)             
            time.sleep(0.1)
         print('同步失败')



led = Pin(2, Pin.OUT)
uart = machine.UART(2, baudrate=115200, rx=13,tx=12,timeout=10)
p22 = Pin(22, Pin.OUT)

readmsg = ''
sendmsg = '1'

WIFI_Connect()
while True:
    sync_ntp()
    dt=time.localtime()
    time.sleep(30)     
    if uart.any() > 0:
        readmsg = uart.read()
        print(readmsg)
        if '2' in readmsg:
            uart.write(sendmsg)
            if dt[3]>=20:
                print('power off')
                p22.on()
                time.sleep(0.5)
                p22.off()

    elif uart.any()==0:                             #多次读取，防止有信息丢失导致误判
        print(dt[3])
        if dt[3]>=6 and dt[3]<20:      #如白天读不到信息则开机
            print('power on')
            p22.on()
            time.sleep(0.5)
            p22.off()