import ntptime
import network,time
from machine import RTC,Pin
from machine import Pin


rtc = RTC()
#print("同步前本地时间：%s" %str(time.localtime()))
led=Pin(2,Pin.OUT)

# 联WIFI
def WIFI_Connect():

    wlan = network.WLAN(network.STA_IF) #STA模式
    wlan.active(True)                   #激活接口
    start_time=time.time()              #记录时间做超时判断
    if not wlan.isconnected():
        print('connecting to network...')
        wlan.connect('HUAWEI-WULIAN', 'onlychina') #输入WIFI账号密码
        while not wlan.isconnected():
            if time.time()-start_time > 15 :
                print('WIFI Connected Timeout!')
                break
    if wlan.isconnected():
        print('connected!')
        print('network information:', wlan.ifconfig())

# 同步时间
def sync_ntp():
     ntptime.NTP_DELTA = 3155644800   # 可选 UTC+8偏移时间（秒），不设置就是UTC0
     ntptime.host = 'ntp1.aliyun.com'  # 可选，ntp服务器，默认是"pool.ntp.org"
     try:
         ntptime.settime()   # 修改设备时间,到这就已经设置好了
     except:
         for i in range(6):
            led.value(1)              #turn off 0是亮
            time.sleep(0.1)
            led.value(0)             
            time.sleep(0.1)
         print('同步失败')

if __name__ == '__main__':
    t=1
    WIFI_Connect()
    p22 = Pin(22, Pin.OUT)   
    while True:
        sync_ntp()
#        print(rtc.datetime())
        dt=time.localtime()
#        print("同步后本地时间：%s" %str(dt))
#        print(str(dt[3]))
        time.sleep(2)
        if dt[3]>=20 and t==0:
            print('power off')
            p22.on()
            time.sleep(0.5)
            p22.off()
            t=1
        elif dt[3]>5 and dt[3]<6 and t==1:
            print('power on')
            p22.on()
            time.sleep(0.5)
            p22.off()            
            t=0
