import os

# ==============================================================================
# 1. frontend/templates/manage.html (v4.8 - Fix Stats Chart & Keep All Features)
# ==============================================================================
manage_html_content = r'''<!DOCTYPE html>
<html lang="zh-CN">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>健身看板 - 后台管理</title>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+SC:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root { --bg-color: #f1f5f9; --panel-color: #ffffff; --accent-color: #0f766e; --accent-color-light: #ccfbf1; --accent-color-soft: #ecfdf5; --accent-danger: #dc2626; --text-primary: #0f172a; --text-secondary: #64748b; --border-soft: #e2e8f0; --shadow-soft: 0 18px 40px rgba(15, 23, 42, 0.12); --radius-lg: 18px; --radius-md: 12px; }
    .hidden { display: none !important; }
    * { box-sizing: border-box; }
    body { margin: 0; font-family: 'Noto Sans SC', 'Roboto', sans-serif; background-color: var(--bg-color); color: var(--text-primary); }
    .app-container { display: flex; min-height: 100vh; }
    .sidebar { width: 260px; background: linear-gradient(180deg, #0f172a, #020617); color: #e5e7eb; display: flex; flex-direction: column; padding: 24px 18px; box-shadow: 6px 0 25px rgba(15, 23, 42, 0.7); position: sticky; top: 0; height: 100vh; }
    .sidebar-header { display: flex; align-items: center; gap: 12px; margin-bottom: 32px; }
    .logo-circle { width: 40px; height: 40px; border-radius: 50%; background: radial-gradient(circle at 30% 20%, #a7f3d0, #16a34a); display: flex; align-items: center; justify-content: center; color: #022c22; font-weight: 800; font-size: 20px; }
    .nav-section-title { font-size: 12px; text-transform: uppercase; letter-spacing: 0.08em; color: #6b7280; margin: 18px 10px 8px; }
    .nav-list { list-style: none; margin: 0; padding: 0; flex: 1; }
    .nav-button { width: 100%; padding: 10px 12px; border-radius: 12px; border: none; background: transparent; color: #d1d5db; font-size: 14px; text-align: left; display: flex; align-items: center; cursor: pointer; transition: all 0.18s ease; margin-bottom: 4px; }
    .nav-button:hover { background: rgba(15, 23, 42, 0.8); transform: translateX(2px); }
    .nav-button.active { background: linear-gradient(90deg, rgba(34, 197, 94, 0.22), rgba(34, 197, 94, 0.04)); color: #ecfdf3; box-shadow: 0 10px 25px rgba(22, 163, 74, 0.5); }
    .nav-button.active::before { content: ''; position: absolute; left: 8px; top: 50%; width: 4px; height: 20px; border-radius: 999px; transform: translateY(-50%); background: #22c55e; }
    .nav-footer { margin-top: 12px; }
    .btn-display { text-decoration:none; font-weight:bold; color:#fff; background:#334155; display:block; text-align:center; padding:12px; border-radius:12px; margin-top:15px; }
    .main { flex: 1; padding: 24px 30px; max-width: calc(100vw - 260px); }
    .panel { background-color: var(--panel-color); border-radius: var(--radius-lg); box-shadow: var(--shadow-soft); padding: 20px 22px; margin-bottom: 18px; border: 1px solid rgba(148, 163, 184, 0.18); }
    .panel-header h2 { margin: 0; font-size: 18px; color: var(--text-primary); }
    .form-group { margin-bottom: 12px; }
    input, select, textarea { width: 100%; padding: 12px; border: 1px solid #cbd5e1; border-radius: var(--radius-md); font-size: 1rem; background: #f8fafc; }
    .btn-submit { background-color: var(--accent-color); color: #ecfdf5; border: none; padding: 10px 18px; border-radius: 999px; cursor: pointer; font-size: 14px; font-weight: 600; }
    .btn-secondary { background-color: #e5e7eb; color: #111827; border: none; padding: 8px 12px; border-radius: 8px; cursor: pointer; font-weight: 500; } 
    .btn-danger { background-color: #ef4444; color: #fff; border: none; padding: 6px 12px; border-radius: 999px; cursor: pointer; font-size: 12px; }
    .btn-add-ex { background-color: #e0f2fe; color: #075985; border: none; padding: 8px 12px; border-radius: 999px; cursor: pointer; font-size: 12px; font-weight: 500; }
    .list-item { padding: 10px 12px; border-radius: 10px; border: 1px solid var(--border-soft); margin-bottom: 8px; background: #f9fafb; display: flex; justify-content: space-between; align-items: center; gap: 10px; }
    .content-section { display: none; }
    .content-section.active { display: block; }
    .exercise-group { display: grid; grid-template-columns: 1fr 1fr; gap: 8px; margin-bottom: 8px; }
    .alert-success { padding: 10px; background: #ecfdf5; color: #166534; margin-bottom: 10px; display:none; border-radius: 8px; }
    .tag-time { background: #e0f2fe; color: #0369a1; padding: 2px 6px; border-radius: 4px; font-size: 11px; margin-left: 6px; font-weight: 600; }
    .iot-table { width: 100%; border-collapse: collapse; font-size: 13px; }
    .iot-table th, .iot-table td { padding: 10px; border-bottom: 1px solid #eee; text-align: left; }
    .iot-table th { background: #f8fafc; color: #64748b; font-weight: 600; }
    .status-Normal { color: #16a34a; font-weight: bold; }
    .status-High, .status-Fever { color: #dc2626; font-weight: bold; }
    .status-Low { color: #ea580c; font-weight: bold; }
    .profile-box { padding: 14px 16px; border-radius: 14px; border: 1px solid #e2e8f0; background: #f9fafb; font-size: 13px; color: #64748b; }
    .profile-box h3 { margin: 0 0 6px; font-size: 15px; color: #0f172a; }
    @media (max-width: 1024px) { .app-container { flex-direction: column; } .sidebar { width: 100%; height: auto; position: static; } .main { max-width: 100%; padding: 16px; } }
  </style>
</head>
<body>
  <div class="app-container">
    <aside class="sidebar">
      <div class="sidebar-header"><div class="logo-circle">F</div><div><div style="font-weight:700">健身看板</div><div style="font-size:12px">后台管理</div></div></div>
      <div class="nav-section-title">任务</div>
      <ul class="nav-list">
        <li><button class="nav-button active" data-tab="daily-todos">✅ 每日待办</button></li>
        <li><button class="nav-button" data-tab="daily-fitness">💪 每日健身</button></li>
        <li><button class="nav-button" data-tab="recurring-todos">🔁 循环待办</button></li>
        <li><button class="nav-button" data-tab="recurring-fitness">📅 循环健身</button></li>
      </ul>
      <div class="nav-section-title">健康 & 系统</div>
      <ul class="nav-list">
        <li><button class="nav-button" data-tab="health">❤️ 健康档案 (IoT)</button></li>
        <li><button class="nav-button" data-tab="stats">📊 统计分析</button></li>
        <li><button class="nav-button" data-tab="mobile-config">📱 移动配置</button></li>
        <li id="userMgmtBtn"><button class="nav-button" data-tab="user-management">👥 用户管理</button></li>
        <li><button class="nav-button" data-tab="profile">⚙️ 个人资料</button></li>
      </ul>
      <div class="nav-footer"><a href="/?view=display" class="btn-display">🖥️ 切换大屏</a></div>
    </aside>

    <main class="main">
      <div class="top-bar"><h1>后台管理中心</h1><span>用户: {{ username }}</span></div>
      <div id="globalAlert" class="alert-success"></div>

      <!-- 1-4 Tasks (Collapsed) -->
      <div id="daily-todos" class="content-section active"><div class="panel"><div class="panel-header"><h2>每日待办 (Today)</h2></div><div style="display:grid;grid-template-columns:1fr 1fr;gap:20px;"><div><div class="form-group"><label>日期:</label><input type="date" id="date-todo"></div><div id="todoList"></div></div><div><h3>+ 待办</h3><form id="addTodoForm"><div class="form-group"><input id="todo-content" placeholder="内容" required></div><div class="form-group"><label>到期:</label><input type="datetime-local" id="todo-reminder"></div><button class="btn-submit">添加</button></form></div></div></div></div>
      <div id="daily-fitness" class="content-section"><div class="panel"><div class="panel-header"><h2>每日健身 (Today)</h2></div><div style="display:grid;grid-template-columns:1fr 1fr;gap:20px;"><div><div class="form-group"><input type="date" id="date-daily"></div><div id="dailyFitnessList"></div></div><div><h3>+ 训练</h3><form id="addManFitForm"><div class="form-group"><input id="mf-name" placeholder="动作" required></div><div class="form-group"><input id="mf-det" placeholder="详情"></div><div class="form-group"><label>到期:</label><input type="datetime-local" id="mf-rem"></div><button class="btn-submit">添加</button></form></div></div></div></div>
      
      <div id="recurring-todos" class="content-section"><div class="panel"><div class="panel-header"><h2>循环待办</h2></div><div id="recTodoList"></div><hr style="margin:15px 0"><div style="display:grid;grid-template-columns:1fr 1fr;gap:20px"><div><h3>+ 新增</h3><form id="addRecTodoForm"><div class="form-group"><div style="display:flex;gap:8px;margin-bottom:5px"><select id="todo-library-select"><option value="">从常用库选择...</option></select><button type="button" id="fillTodoLib" class="btn-add-ex">填入</button></div><input id="rec-todo-content" placeholder="内容" required></div><div class="exercise-group"><input type="date" id="rec-todo-start"><input type="date" id="rec-todo-end"></div><div class="form-group"><label>提醒点:</label><input type="time" id="rec-todo-time"></div><div class="form-group"><select id="rec-todo-interval"><option value="daily">每日</option><option value="weekly">每周</option><option value="monthly">每月</option></select></div><div class="hidden" id="rec-todo-week-box"><select id="rec-todo-day-w"><option value="1">一</option><option value="2">二</option><option value="3">三</option><option value="4">四</option><option value="5">五</option><option value="6">六</option><option value="7">日</option></select></div><div class="hidden" id="rec-todo-month-box"><input type="number" id="rec-todo-day-m" min="1" max="31" value="1"></div><button class="btn-submit">保存</button></form></div><div style="background:#f8fafc;padding:15px;border-radius:10px;border:1px solid #e2e8f0"><h3 style="margin-top:0">常用待办库</h3><form id="todoLibraryForm" style="display:flex;gap:10px;margin-bottom:10px"><input id="lib-todo-content" placeholder="内容"><button class="btn-submit">入库</button></form><div id="todoLibraryList" style="max-height:300px;overflow-y:auto"></div></div></div></div></div>
      
      <div id="recurring-fitness" class="content-section"><div class="panel"><div class="panel-header"><h2>循环健身</h2></div><div id="recPlanList"></div><hr style="margin:15px 0"><div style="display:grid;grid-template-columns:1fr 1fr;gap:20px"><div><h3>+ 新增</h3><form id="addRecPlanForm"><div class="form-group"><input id="rec-plan-name" placeholder="计划名" required></div><div class="exercise-group"><input type="date" id="rec-plan-start"><input type="date" id="rec-plan-end"></div><div class="form-group"><label>提醒点:</label><input type="time" id="rec-plan-time"></div><div class="form-group"><select id="rec-plan-interval"><option value="daily">每日</option><option value="weekly">每周</option></select></div><div class="hidden" id="rec-plan-week-box"><select id="rec-plan-day-w"><option value="1">一</option><option value="2">二</option><option value="3">三</option><option value="4">四</option><option value="5">五</option><option value="6">六</option><option value="7">日</option></select></div><div style="display:flex;gap:8px;margin-bottom:10px"><select id="ex-lib-select"><option value="">从训练库选择...</option></select><button type="button" id="addFromLibBtn" class="btn-add-ex">添加</button></div><div id="ex-container"><div class="exercise-group"><input class="ex-n" placeholder="动作"><input class="ex-d" placeholder="组数"></div></div><button type="button" id="addExBtn" class="btn-add-ex">+ 动作</button><br><br><button class="btn-submit">保存</button></form></div><div style="background:#f8fafc;padding:15px;border-radius:10px;border:1px solid #e2e8f0"><h3 style="margin-top:0">训练项目库</h3><form id="exLibForm" style="display:flex;gap:10px;margin-bottom:10px"><input id="lib-ex-name" placeholder="动作"><input id="lib-ex-det" placeholder="组数"><button class="btn-submit">入库</button></form><div id="exLibraryList" style="max-height:300px;overflow-y:auto"></div></div></div></div></div>

      <!-- Health Tab -->
      <div id="health" class="content-section"><div class="panel"><div class="panel-header"><h2>健康档案 (IoT Center)</h2></div><div class="section-grid" style="display:grid;grid-template-columns:1fr 2fr;gap:20px"><div class="profile-box"><h3>身体参数设置</h3><form id="bioForm"><div class="form-group"><label>年龄:</label><input type="number" id="bio-age" value="{{ user_info.age }}"></div><div class="form-group"><label>性别:</label><select id="bio-gender"><option value="M">男</option><option value="F">女</option></select></div><div class="exercise-group"><div class="form-group"><label>身高(cm):</label><input type="number" id="bio-height" value="{{ user_info.height }}"></div><div class="form-group"><label>体重(kg):</label><input type="number" id="bio-weight" value="{{ user_info.weight }}"></div></div><button type="submit" class="btn-submit">保存</button></form><hr><h3>MQTT 测试</h3><button onclick="simMqtt('bp_sys', 135)" class="btn-add-ex">模拟高血压</button></div><div><h3>最近数据</h3><button class="btn-secondary" onclick="loadHealthLogs()" style="float:right;margin-top:-30px">刷新</button><div style="overflow-y:auto;max-height:500px;border:1px solid #eee;border-radius:8px;"><table class="iot-table"><thead><tr><th>时间</th><th>指标</th><th>数值</th><th>分析</th></tr></thead><tbody id="healthLogBody"><tr><td colspan="4">加载中...</td></tr></tbody></table></div></div></div></div></div>

      <!-- Stats (FIXED) -->
      <div id="stats" class="content-section">
        <div class="panel">
            <div class="panel-header"><h2>统计分析</h2></div>
            <div style="display:flex;gap:10px;margin-bottom:20px;align-items:center">
                <input type="date" id="stats-s"> <span style="color:#999">至</span> <input type="date" id="stats-e">
                <button class="btn-secondary" onclick="loadStats()">刷新数据</button>
            </div>
            <div style="height:400px"><canvas id="statsChart"></canvas></div>
        </div>
      </div>
      
      <!-- Mobile Config (With Speed) -->
      <div id="mobile-config" class="content-section">
        <div class="panel">
            <div class="panel-header"><h2>移动端配置</h2></div>
            <div class="panel-body">
                <div class="profile-box" style="margin-bottom:20px">
                    <h3>大屏字幕滚动速度</h3>
                    <form id="scrollSpeedForm" style="display:flex;gap:10px;align-items:center">
                        <input type="number" id="scroll-speed-input" min="1" max="120" style="width:80px"> <span>秒/轮</span>
                        <button type="submit" class="btn-submit">保存设置</button>
                    </form>
                </div>
                <iframe src="/mobile_config" style="width:100%;height:500px;border:0"></iframe>
            </div>
        </div>
      </div>

      <!-- User Mgmt & Profile -->
      <div id="user-management" class="content-section"><div class="panel"><h2>用户管理</h2><div id="userList"></div><h3>新增用户</h3><form id="addUserForm"><div class="form-group"><input id="nu-name" placeholder="用户" required></div><div class="form-group"><input id="nu-pass" placeholder="密码" required></div><label><input type="checkbox" id="nu-admin"> 管理员</label><br><br><button class="btn-submit">创建</button></form></div></div>
      <div id="profile" class="content-section"><div class="panel"><h2>资料</h2><form id="profForm"><input id="pu-name" placeholder="新名"><br><input id="pu-pass" placeholder="新密"><br><button class="btn-submit">更新</button></form></div></div>

    </main>
  </div>

<script>
const todayStr = new Date().toISOString().slice(0,10);
const api = async (u, o) => (await fetch(u, {credentials:'include', ...o})).json();
function msg(t) { const e=document.getElementById('globalAlert'); e.textContent=t; e.style.display='block'; setTimeout(()=>e.style.display='none',3000); }

document.querySelectorAll('.nav-button').forEach(b => b.addEventListener('click', () => {
    if(b.classList.contains('btn-display-link')) return;
    document.querySelectorAll('.nav-button').forEach(x=>x.classList.remove('active'));
    document.querySelectorAll('.content-section').forEach(x=>x.classList.remove('active'));
    b.classList.add('active');
    document.getElementById(b.dataset.tab).classList.add('active');
    if(b.dataset.tab === 'health') loadHealthLogs();
    else if(b.dataset.tab === 'mobile-config') loadScrollSpeed();
    else if(b.dataset.tab === 'stats') loadStats();
    else refreshAll();
}));

document.addEventListener('DOMContentLoaded', ()=>{
    ['date-todo','date-daily','rec-todo-start','rec-plan-start'].forEach(i=>{ const el=document.getElementById(i); if(el) el.value=todayStr; });
    document.getElementById('rec-todo-interval').dispatchEvent(new Event('change'));
    document.getElementById('rec-plan-interval').dispatchEvent(new Event('change'));
    const g = "{{ user_info.gender }}"; if(g && g!=='None') document.getElementById('bio-gender').value = g;
    
    // Init Stats Dates
    const d = new Date(); document.getElementById('stats-e').value = d.toISOString().split('T')[0];
    d.setDate(d.getDate()-7); document.getElementById('stats-s').value = d.toISOString().split('T')[0];
    
    refreshAll();
    loadScrollSpeed();
    loadStats(); // Auto load chart
});

function refreshAll() {
    loadTodos(document.getElementById('date-todo').value);
    loadFitness(document.getElementById('date-daily').value);
    loadRecTodos(); loadRecPlans(); loadUsers();
    loadExLib(); loadTodoLib(); 
}

// Logic - Tasks
async function loadTodos(d){ const l=await api(`/todos?date=${d}`); document.getElementById('todoList').innerHTML=l.map(t=>`<div class="list-item"><div>${t.is_completed?'✅':'⬜'} ${t.content}</div><button class="btn-danger" onclick="del('delete_todo',${t.id})">删</button></div>`).join(''); }
document.getElementById('date-todo').onchange=(e)=>loadTodos(e.target.value);
document.getElementById('addTodoForm').onsubmit=async(e)=>{e.preventDefault(); let rem=document.getElementById('todo-reminder').value.replace('T',' '); await api('/add_todo',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({date:document.getElementById('date-todo').value,content:document.getElementById('todo-content').value,reminder_at:rem})}); e.target.reset(); loadTodos(document.getElementById('date-todo').value);}
async function loadFitness(d){ const l=await api(`/fitness_plan/${d}`); document.getElementById('dailyFitnessList').innerHTML=l.map(p=>`<div class="list-item"><div>${p.exercise_name}</div><button class="btn-danger" onclick="del('delete_fitness_plan_exercise',${p.id})">删</button></div>`).join(''); }
document.getElementById('date-daily').onchange=(e)=>loadFitness(e.target.value);
document.getElementById('addManFitForm').onsubmit=async(e)=>{e.preventDefault(); let rem=document.getElementById('mf-rem').value.replace('T',' '); await api('/add_fitness_manual',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({date:document.getElementById('date-daily').value,exercise_name:document.getElementById('mf-name').value,sets_reps_duration:document.getElementById('mf-det').value,reminder_at:rem})}); e.target.reset(); loadFitness(document.getElementById('date-daily').value);}
async function loadRecTodos(){ const l=await api('/get_recurring_todos'); document.getElementById('recTodoList').innerHTML=l.map(t=>`<div class="list-item"><div>${t.content}</div><button class="btn-danger" onclick="del('delete_recurring_todo',${t.id})">删</button></div>`).join(''); }
async function loadTodoLib(){ const l=await api('/api/todo_library'); const s=document.getElementById('todo-library-select'); s.innerHTML='<option value="">选...</option>'; l.forEach(i=>{const o=document.createElement('option');o.value=i.content;o.text=i.content;s.add(o);}); document.getElementById('todoLibraryList').innerHTML=l.map(i=>`<div class="list-item"><span>${i.content}</span><button class="btn-danger" onclick="del('api/todo_library',${i.id})">删</button></div>`).join(''); }
document.getElementById('todoLibraryForm').onsubmit=async(e)=>{e.preventDefault(); await api('/api/todo_library',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({content:document.getElementById('lib-todo-content').value})}); e.target.reset(); loadTodoLib();}
document.getElementById('fillTodoLib').onclick=()=>{ document.getElementById('rec-todo-content').value = document.getElementById('todo-library-select').value; };
document.getElementById('addRecTodoForm').onsubmit=async(e)=>{e.preventDefault(); await api('/add_recurring_todo',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({content:document.getElementById('rec-todo-content').value,start_date:document.getElementById('rec-todo-start').value,end_date:document.getElementById('rec-todo-end').value||null,repeat_interval:document.getElementById('rec-todo-interval').value,repeat_day:document.getElementById('rec-todo-interval').value==='weekly'?document.getElementById('rec-todo-day-w').value:document.getElementById('rec-todo-day-m').value,reminder_time:document.getElementById('rec-todo-time').value})}); e.target.reset(); loadRecTodos();}
document.getElementById('rec-todo-interval').onchange=(e)=>{document.getElementById('rec-todo-week-box').classList.toggle('hidden',e.target.value!=='weekly');document.getElementById('rec-todo-month-box').classList.toggle('hidden',e.target.value!=='monthly');}
async function loadRecPlans(){ const l=await api('/get_recurring_plans'); document.getElementById('recPlanList').innerHTML=l.map(p=>`<div class="list-item"><div>${p.plan_name}</div><button class="btn-danger" onclick="del('delete_recurring_plan',${p.id})">删</button></div>`).join(''); }
async function loadExLib(){ const l=await api('/api/exercises'); const s=document.getElementById('ex-lib-select'); s.innerHTML='<option value="">选...</option>'; l.forEach(i=>{const o=document.createElement('option');o.text=i.name;o.dataset.n=i.name;o.dataset.d=i.details;s.add(o);}); document.getElementById('exLibraryList').innerHTML=l.map(i=>`<div class="list-item"><span>${i.name}</span><button class="btn-danger" onclick="del('api/exercises',${i.id})">删</button></div>`).join(''); }
document.getElementById('exLibForm').onsubmit=async(e)=>{e.preventDefault(); await api('/api/exercises',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({name:document.getElementById('lib-ex-name').value,details:document.getElementById('lib-ex-det').value})}); e.target.reset(); loadExLib();}
document.getElementById('addFromLibBtn').onclick=()=>{const o=document.getElementById('ex-lib-select').selectedOptions[0]; if(o.value) document.getElementById('ex-container').insertAdjacentHTML('beforeend',`<div class="exercise-group"><input class="ex-n" value="${o.dataset.n}"><input class="ex-d" value="${o.dataset.d}"></div>`);}
document.getElementById('addExBtn').onclick=()=>{document.getElementById('ex-container').insertAdjacentHTML('beforeend','<div class="exercise-group"><input class="ex-n" placeholder="动作"><input class="ex-d" placeholder="组数"></div>')}
document.getElementById('addRecPlanForm').onsubmit=async(e)=>{e.preventDefault(); const exs=[...document.querySelectorAll('.ex-n')].map((x,i)=>({name:x.value,details:document.querySelectorAll('.ex-d')[i].value})).filter(x=>x.name); await api('/add_recurring_plan',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({plan_name:document.getElementById('rec-plan-name').value,start_date:document.getElementById('rec-plan-start').value,end_date:document.getElementById('rec-plan-end').value||null,repeat_interval:document.getElementById('rec-plan-interval').value,repeat_day:document.getElementById('rec-plan-day-w').value,reminder_time:document.getElementById('rec-plan-time').value,exercises:exs})}); e.target.reset(); document.getElementById('ex-container').innerHTML='<div class="exercise-group"><input class="ex-n" placeholder="动作"><input class="ex-d" placeholder="组数"></div>'; loadRecPlans();}
document.getElementById('rec-plan-interval').onchange=(e)=>{document.getElementById('rec-plan-week-box').classList.toggle('hidden',e.target.value!=='weekly');}
async function loadHealthLogs(){const l=await api('/api/health_logs');document.getElementById('healthLogBody').innerHTML=l.length?l.map(x=>`<tr><td>${x.recorded_at}</td><td>${x.metric_type}</td><td>${x.value} ${x.unit}</td><td class="status-${x.analysis.split(' ')[0]}">${x.analysis}</td></tr>`).join(''):'<tr><td colspan="4">无数据</td></tr>';}
document.getElementById('bioForm').onsubmit=async(e)=>{e.preventDefault();await api('/api/profile/bio',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({age:document.getElementById('bio-age').value,gender:document.getElementById('bio-gender').value,weight:document.getElementById('bio-weight').value,height:document.getElementById('bio-height').value})});msg('参数已保存');}
function simMqtt(t,v){alert(`请运行: mosquitto_pub -t "health/{{ current_user.id }}/${t}" -m "${v}"`);}
async function loadScrollSpeed(){ const d=await api('/api/settings/scroll_speed'); document.getElementById('scroll-speed-input').value = d.scroll_speed; }
document.getElementById('scrollSpeedForm').onsubmit=async(e)=>{e.preventDefault(); await api('/api/settings/scroll_speed',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({scroll_speed:document.getElementById('scroll-speed-input').value})}); msg('速度已更新');}
async function loadUsers(){ try{const u=await api('/api/users'); document.getElementById('userList').innerHTML=u.map(x=>`<div class="list-item"><span>${x.username}</span><button class="btn-danger" onclick="delUser(${x.id})">删</button></div>`).join('');}catch{document.getElementById('userMgmtBtn').style.display='none';} }
document.getElementById('addUserForm').onsubmit=async(e)=>{e.preventDefault();await api('/api/users',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({username:document.getElementById('nu-name').value,password:document.getElementById('nu-pass').value,is_admin:document.getElementById('nu-admin').checked?1:0})});e.target.reset();loadUsers();}
async function delUser(id){if(confirm('Del?'))await api(`/api/users/${id}`,{method:'DELETE'});loadUsers();}
document.getElementById('profForm').onsubmit=async(e)=>{e.preventDefault();await api('/api/profile',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({username:document.getElementById('pu-name').value,password:document.getElementById('pu-pass').value})});msg('资料更新');}
async function del(ep,id){if(confirm('Del?')){await api(`/${ep}/${id}`,{method:'DELETE'});refreshAll();}}

// ★★★ FIXED CHART LOGIC ★★★
let chart; 
async function loadStats(){
    const d=await api(`/api/stats/daily_completion?start_date=${document.getElementById('stats-s').value}&end_date=${document.getElementById('stats-e').value}`);
    // Consolidate keys to ensure chart draws even if one side is empty
    const allKeys = new Set([...Object.keys(d.todo_data||{}), ...Object.keys(d.fitness_data||{})]);
    const l = Array.from(allKeys).sort();
    
    if(chart) chart.destroy();
    chart = new Chart(document.getElementById('statsChart'), {
        type: 'line',
        data: {
            labels: l,
            datasets: [
                { label: '待办完成', data: l.map(k=>(d.todo_data[k]?d.todo_data[k].completed:0)), borderColor: '#22c55e', tension:0.1 },
                { label: '健身完成', data: l.map(k=>(d.fitness_data[k]?d.fitness_data[k].completed:0)), borderColor: '#0ea5e9', tension:0.1 }
            ]
        },
        options: { scales: { y: { beginAtZero: true, ticks: { stepSize: 1 } } } }
    });
}
</script>
</body>
</html>
'''

def write_file(filename, content, folder="."):
    filepath = os.path.join(folder, filename)
    try:
        with open(filepath, 'w', encoding='utf-8') as f: f.write(content)
        print(f"[OK] Updated: {filepath}")
    except Exception as e: print(f"[ERR] Failed {filepath}: {e}")

def main():
    print("=== V4.8 Update: Fix Stats & Restore Libs ===")
    td = "templates" if os.path.exists("templates") else ("frontend/templates" if os.path.exists("frontend/templates") else ".")
    write_file('manage.html', manage_html_content, td)
    print("\nDone. Reload Manage Page.")

if __name__ == '__main__': main()
