import paho.mqtt.client as mqtt
import time
import json
import random

# === 修改这里 ===
# 如果是在树莓派本机运行，使用 127.0.0.1
# 如果是在电脑上运行连接树莓派，使用树莓派的 IP (如 192.168.10.59)
BROKER_ADDRESS = "127.0.0.1" 
BROKER_PORT = 1883
USER_ID = 1
# ===============

def on_connect(client, userdata, flags, rc, properties=None):
    if rc == 0:
        print(f"✅ 成功连接到 MQTT 服务器: {BROKER_ADDRESS}")
    else:
        print(f"❌ 连接失败，错误码: {rc}")

# 兼容不同版本的 paho-mqtt
try:
    client = mqtt.Client(mqtt.CallbackAPIVersion.VERSION1)
except AttributeError:
    client = mqtt.Client()

client.on_connect = on_connect

print(f"正在尝试连接 MQTT 服务器 {BROKER_ADDRESS}...")
try:
    client.connect(BROKER_ADDRESS, BROKER_PORT, 60)
except Exception as e:
    print(f"❌ 连接失败: {e}")
    print("请确保运行了: sudo systemctl start mosquitto")
    exit()

client.loop_start()

def publish_data(metric, value, unit):
    topic = f"health/{USER_ID}/{metric}"
    payload = json.dumps({"value": value, "unit": unit})
    client.publish(topic, payload)
    print(f"  [发送] {metric:<10} : {value} {unit}")

tick = 0
try:
    while True:
        is_abnormal = random.random() < 0.1
        
        if tick % 5 == 0:
            hr = random.randint(110, 130) if is_abnormal else random.randint(60, 90)
            publish_data("hr", hr, "bpm")

        if tick % 10 == 0:
            sys = random.randint(145, 160) if is_abnormal else random.randint(110, 125)
            publish_data("bp_sys", sys, "mmHg")
            
        tick += 5
        time.sleep(5)
except KeyboardInterrupt:
    client.loop_stop()
    client.disconnect()
