import sys
import os
from flask import Flask, render_template

# --- 核心修改：适配 Nuitka 在 Linux 下的路径逻辑 ---
if getattr(sys, 'frozen', False):
    # 情况1：如果是 Nuitka 编译后的二进制文件运行
    # 在 Linux Onefile 模式下，文件会被解压到临时目录，__file__ 指向该临时位置
    base_dir = os.path.dirname(__file__)
else:
    # 情况2：如果是直接用 python app.py 运行源代码
    base_dir = os.path.dirname(os.path.abspath(__file__))

# 显式告诉 Flask 模板和静态文件在哪里
template_dir = os.path.join(base_dir, 'templates')
static_dir = os.path.join(base_dir, 'static')

app = Flask(__name__, template_folder=template_dir, static_folder=static_dir)
# --- 修改结束 ---

@app.route('/')
def index():
    # 页面内容配置
    content = {
        "title": "Smart LifeOS",
        "subtitle": "重塑你的日常秩序",
        "hero_text": "智能健身 & 待办管理",
        "hero_sub": "不仅仅是清单。这是一个帮助你建立习惯、管理健康、从容生活的全功能数字化系统。",
        "cta_btn": "开始体验",
        "features": [
            {
                "title": "沉浸式大屏看板",
                "desc": "专为电视和显示器设计的暗色模式。让你的今日计划一目了然，成为家中的数字装饰。",
                "img": "dark_mode.jpg",
                "tag": "Visual Experience"
            },
            {
                "title": "智能循环逻辑",
                "desc": "设定一次，自动生成。无论是每周二的“买牛奶”还是“周一练胸日”，系统自动为你规划。",
                "img": "recurring.jpg",
                "tag": "Automation"
            },
            {
                "title": "可视化数据洞察",
                "desc": "直观的图表统计。看着完成率曲线稳步上升，是对坚持最好的奖励。",
                "img": "stats.jpg",
                "tag": "Analytics"
            }
        ]
    }
    return render_template('index.html', content=content)

if __name__ == '__main__':
    # host='0.0.0.0' 允许局域网其他设备访问
    # threaded=True 开启多线程，处理并发请求更流畅
    app.run(host='0.0.0.0', port=5000, threaded=True)

